jQuery( document ).ready(function($) {

	jQuery('select.designervily-select-icon-library').on('change', function(){

		console.log('Select Changed');

		var cust_ele     = jQuery(this).closest('.customize-control.customize-control-designervily_icon_picker');
		var input_ele    = jQuery('.kirki-designervily-icon-picker-control' , cust_ele );

		jQuery( '.designervily-select-icon-list-wrapper', cust_ele ).hide();
		jQuery( '.designervily-select-icon-list-wrapper-' + jQuery(this).val() , cust_ele ).show();

		// Update value
		var finalval = dsvy_icon_picker_update_value( jQuery(this).val() );
		jQuery( input_ele ).val( finalval ).trigger('change'); // all library value

	});

	/* Open icon picker list */
	jQuery('.designervily-icon-picker-ele-arrow').on('click',function(){

		var mainele      = jQuery(this).closest('.designervily-select-icon-list-wrapper');
		var cust_ele     = jQuery(this).closest('.customize-control.customize-control-designervily_icon_picker');
		var input_ele    = jQuery('.kirki-designervily-icon-picker-control' , cust_ele );
		var icon_preview = jQuery('.designervily-icon-picker-ele-icon' , cust_ele );
		var full_class   = '';
		var active_class = '';
		var library      = jQuery(this).closest('.designervily-icon-picker-ele-w').data('dsvy-library');
		var icon         = jQuery(this).closest('.designervily-icon-picker-ele-w').data('dsvy-selected-icon');
		var common_class = jQuery(this).closest('.designervily-icon-picker-ele-w').data('dsvy-common-class');
		var class_prefix = jQuery(this).closest('.designervily-icon-picker-ele-w').data('dsvy-class-prefix');
		var selected_icon = jQuery(this).closest('.designervily-icon-picker-ele-w').data('dsvy-selected-icon');

		library_array = library.replace(/#|-/g,'_'); // result: "this is a test"

		/* Icon Selector Builder */
		if( !jQuery( '.designervily-icon-picker-list-w', mainele ).hasClass('designervily-icon-picker-list-filled') ){

			// Building icon picker now
			var icon_array = window['iconarray_' + library_array ];
			var picker_html = '<ul class="dsvy-icon-picker-list">';
			jQuery.each( icon_array, function( index, value ) {
				full_class = common_class + ' ' + class_prefix + value;
				active_class = '';
				if( selected_icon == full_class ){
					active_class = ' class="designervily-active-icon" ';
				}
				picker_html += '<li'+active_class+'><a href="#"><i class="' + full_class + '"></i></a></li>';

			});
			picker_html += '</ul>';

			// adding HTML list in the div
			jQuery( '.designervily-icon-picker-list-w', mainele ).html(picker_html);
			jQuery( '.designervily-icon-picker-list-w', mainele ).addClass('designervily-icon-picker-list-filled');

			// applying click event
			jQuery( '.designervily-icon-picker-list-w a', mainele ).on( 'click', function(){
				console.log('CALLED');
				var currclass = jQuery( 'i', this).attr('class');
				jQuery( '.designervily-icon-picker-list-w li', mainele ).removeClass('designervily-active-icon');
				jQuery( this ).parent().addClass('designervily-active-icon');
				console.log(library);
				console.log(currclass);
				jQuery( '.designervily-select-icon-list-wrapper-'+library+' .designervily-icon-picker-ele-icon i', cust_ele ).attr( 'class', currclass ); // preview icon
				var finalval = dsvy_icon_picker_update_value( library,  cust_ele);

				console.log(finalval);
				console.log( 'Prev:' );
				console.log( jQuery( input_ele ).val() );
				jQuery( input_ele ).val( finalval ).trigger('change'); // all library value
				console.log( 'Next:' );
				console.log( jQuery( input_ele ).val() );
				return false;
			});
		}

		// Change arrow on click
		if( jQuery('.designervily-icon-picker-ele-arrow i', mainele ).hasClass('fa-arrow-down') ){
			jQuery('.designervily-icon-picker-ele-arrow i', mainele ).removeClass('fa-arrow-down').addClass('fa-arrow-up');
		} else {
			jQuery('.designervily-icon-picker-ele-arrow i', mainele ).removeClass('fa-arrow-up').addClass('fa-arrow-down');
		}

		// Open/close icon picker list
		jQuery( '.designervily-icon-picker-list-w', mainele ).slideToggle();

	});

});

function dsvy_icon_picker_update_value( firstlib, cust_ele ){

	cust_ele		= jQuery(cust_ele);
	var library		= '';
	var returndata	= '';

	returndata = jQuery('.designervily-select-icon-list-wrapper.designervily-select-icon-list-wrapper-'+firstlib + ' .designervily-icon-picker-ele-icon i', cust_ele ).attr('class');

	jQuery('.designervily-icon-picker-ele-w').each(function(){
		library = jQuery(this).data('dsvy-library');
		if( library != firstlib ){
			returndata += ';'+jQuery('.designervily-select-icon-list-wrapper.designervily-select-icon-list-wrapper-'+library + ' .designervily-icon-picker-ele-icon i', cust_ele ).attr('class');
		}
	});

	return returndata;
}

/**
 * Icon List array
 */
var iconarray_elementor_icons_fa_regular = [
	'',
	'address-book',
	'address-card',
	'angry',
	'arrow-alt-circle-down',
	'arrow-alt-circle-left',
	'arrow-alt-circle-right',
	'arrow-alt-circle-up',
	'bell',
	'bell-slash',
	'bookmark',
	'building',
	'calendar',
	'calendar-alt',
	'calendar-check',
	'calendar-minus',
	'calendar-plus',
	'calendar-times',
	'caret-square-down',
	'caret-square-left',
	'caret-square-right',
	'caret-square-up',
	'chart-bar',
	'check-circle',
	'check-square',
	'circle',
	'clipboard',
	'clock',
	'clone',
	'closed-captioning',
	'comment',
	'comment-alt',
	'comment-dots',
	'comments',
	'compass',
	'copy',
	'copyright',
	'credit-card',
	'dizzy',
	'dot-circle',
	'edit',
	'envelope',
	'envelope-open',
	'eye',
	'eye-slash',
	'file',
	'file-alt',
	'file-archive',
	'file-audio',
	'file-code',
	'file-excel',
	'file-image',
	'file-pdf',
	'file-powerpoint',
	'file-video',
	'file-word',
	'flag',
	'flushed',
	'folder',
	'folder-open',
	'frown',
	'frown-open',
	'futbol',
	'gem',
	'grimace',
	'grin',
	'grin-alt',
	'grin-beam',
	'grin-beam-sweat',
	'grin-hearts',
	'grin-squint',
	'grin-squint-tears',
	'grin-stars',
	'grin-tears',
	'grin-tongue',
	'grin-tongue-squint',
	'grin-tongue-wink',
	'grin-wink',
	'hand-lizard',
	'hand-paper',
	'hand-peace',
	'hand-point-down',
	'hand-point-left',
	'hand-point-right',
	'hand-point-up',
	'hand-pointer',
	'hand-rock',
	'hand-scissors',
	'hand-spock',
	'handshake',
	'hdd',
	'heart',
	'hospital',
	'hourglass',
	'id-badge',
	'id-card',
	'image',
	'images',
	'keyboard',
	'kiss',
	'kiss-beam',
	'kiss-wink-heart',
	'laugh',
	'laugh-beam',
	'laugh-squint',
	'laugh-wink',
	'lemon',
	'life-ring',
	'lightbulb',
	'list-alt',
	'map',
	'meh',
	'meh-blank',
	'meh-rolling-eyes',
	'minus-square',
	'money-bill-alt',
	'moon',
	'newspaper',
	'object-group',
	'object-ungroup',
	'paper-plane',
	'pause-circle',
	'play-circle',
	'plus-square',
	'question-circle',
	'registered',
	'sad-cry',
	'sad-tear',
	'save',
	'share-square',
	'smile',
	'smile-beam',
	'smile-wink',
	'snowflake',
	'square',
	'star',
	'star-half',
	'sticky-note',
	'stop-circle',
	'sun',
	'surprise',
	'thumbs-down',
	'thumbs-up',
	'times-circle',
	'tired',
	'trash-alt',
	'user',
	'user-circle',
	'window-close',
	'window-maximize',
	'window-minimize',
	'window-restore'
];

var iconarray_elementor_icons_fa_solid = [
	'',
	'ad',
	'address-book',
	'address-card',
	'adjust',
	'air-freshener',
	'align-center',
	'align-justify',
	'align-left',
	'align-right',
	'allergies',
	'ambulance',
	'american-sign-language-interpreting',
	'anchor',
	'angle-double-down',
	'angle-double-left',
	'angle-double-right',
	'angle-double-up',
	'angle-down',
	'angle-left',
	'angle-right',
	'angle-up',
	'angry',
	'ankh',
	'apple-alt',
	'archive',
	'archway',
	'arrow-alt-circle-down',
	'arrow-alt-circle-left',
	'arrow-alt-circle-right',
	'arrow-alt-circle-up',
	'arrow-circle-down',
	'arrow-circle-left',
	'arrow-circle-right',
	'arrow-circle-up',
	'arrow-down',
	'arrow-left',
	'arrow-right',
	'arrow-up',
	'arrows-alt',
	'arrows-alt-h',
	'arrows-alt-v',
	'assistive-listening-systems',
	'asterisk',
	'at',
	'atlas',
	'atom',
	'audio-description',
	'award',
	'baby',
	'baby-carriage',
	'backspace',
	'backward',
	'bacon',
	'bahai',
	'balance-scale',
	'balance-scale-left',
	'balance-scale-right',
	'ban',
	'band-aid',
	'barcode',
	'bars',
	'baseball-ball',
	'basketball-ball',
	'bath',
	'battery-empty',
	'battery-full',
	'battery-half',
	'battery-quarter',
	'battery-three-quarters',
	'bed',
	'beer',
	'bell',
	'bell-slash',
	'bezier-curve',
	'bible',
	'bicycle',
	'biking',
	'binoculars',
	'biohazard',
	'birthday-cake',
	'blender',
	'blender-phone',
	'blind',
	'blog',
	'bold',
	'bolt',
	'bomb',
	'bone',
	'bong',
	'book',
	'book-dead',
	'book-medical',
	'book-open',
	'book-reader',
	'bookmark',
	'border-all',
	'border-none',
	'border-style',
	'bowling-ball',
	'box',
	'box-open',
	'boxes',
	'braille',
	'brain',
	'bread-slice',
	'briefcase',
	'briefcase-medical',
	'broadcast-tower',
	'broom',
	'brush',
	'bug',
	'building',
	'bullhorn',
	'bullseye',
	'burn',
	'bus',
	'bus-alt',
	'business-time',
	'calculator',
	'calendar',
	'calendar-alt',
	'calendar-check',
	'calendar-day',
	'calendar-minus',
	'calendar-plus',
	'calendar-times',
	'calendar-week',
	'camera',
	'camera-retro',
	'campground',
	'candy-cane',
	'cannabis',
	'capsules',
	'car',
	'car-alt',
	'car-battery',
	'car-crash',
	'car-side',
	'caravan',
	'caret-down',
	'caret-left',
	'caret-right',
	'caret-square-down',
	'caret-square-left',
	'caret-square-right',
	'caret-square-up',
	'caret-up',
	'carrot',
	'cart-arrow-down',
	'cart-plus',
	'cash-register',
	'cat',
	'certificate',
	'chair',
	'chalkboard',
	'chalkboard-teacher',
	'charging-station',
	'chart-area',
	'chart-bar',
	'chart-line',
	'chart-pie',
	'check',
	'check-circle',
	'check-double',
	'check-square',
	'cheese',
	'chess',
	'chess-bishop',
	'chess-board',
	'chess-king',
	'chess-knight',
	'chess-pawn',
	'chess-queen',
	'chess-rook',
	'chevron-circle-down',
	'chevron-circle-left',
	'chevron-circle-right',
	'chevron-circle-up',
	'chevron-down',
	'chevron-left',
	'chevron-right',
	'chevron-up',
	'child',
	'church',
	'circle',
	'circle-notch',
	'city',
	'clinic-medical',
	'clipboard',
	'clipboard-check',
	'clipboard-list',
	'clock',
	'clone',
	'closed-captioning',
	'cloud',
	'cloud-download-alt',
	'cloud-meatball',
	'cloud-moon',
	'cloud-moon-rain',
	'cloud-rain',
	'cloud-showers-heavy',
	'cloud-sun',
	'cloud-sun-rain',
	'cloud-upload-alt',
	'cocktail',
	'code',
	'code-branch',
	'coffee',
	'cog',
	'cogs',
	'coins',
	'columns',
	'comment',
	'comment-alt',
	'comment-dollar',
	'comment-dots',
	'comment-medical',
	'comment-slash',
	'comments',
	'comments-dollar',
	'compact-disc',
	'compass',
	'compress',
	'compress-alt',
	'compress-arrows-alt',
	'concierge-bell',
	'cookie',
	'cookie-bite',
	'copy',
	'copyright',
	'couch',
	'credit-card',
	'crop',
	'crop-alt',
	'cross',
	'crosshairs',
	'crow',
	'crown',
	'crutch',
	'cube',
	'cubes',
	'cut',
	'database',
	'deaf',
	'democrat',
	'desktop',
	'dharmachakra',
	'diagnoses',
	'dice',
	'dice-d20',
	'dice-d6',
	'dice-five',
	'dice-four',
	'dice-one',
	'dice-six',
	'dice-three',
	'dice-two',
	'digital-tachograph',
	'directions',
	'divide',
	'dizzy',
	'dna',
	'dog',
	'dollar-sign',
	'dolly',
	'dolly-flatbed',
	'donate',
	'door-closed',
	'door-open',
	'dot-circle',
	'dove',
	'download',
	'drafting-compass',
	'dragon',
	'draw-polygon',
	'drum',
	'drum-steelpan',
	'drumstick-bite',
	'dumbbell',
	'dumpster',
	'dumpster-fire',
	'dungeon',
	'edit',
	'egg',
	'eject',
	'ellipsis-h',
	'ellipsis-v',
	'envelope',
	'envelope-open',
	'envelope-open-text',
	'envelope-square',
	'equals',
	'eraser',
	'ethernet',
	'euro-sign',
	'exchange-alt',
	'exclamation',
	'exclamation-circle',
	'exclamation-triangle',
	'expand',
	'expand-alt',
	'expand-arrows-alt',
	'external-link-alt',
	'external-link-square-alt',
	'eye',
	'eye-dropper',
	'eye-slash',
	'fan',
	'fast-backward',
	'fast-forward',
	'fax',
	'feather',
	'feather-alt',
	'female',
	'fighter-jet',
	'file',
	'file-alt',
	'file-archive',
	'file-audio',
	'file-code',
	'file-contract',
	'file-csv',
	'file-download',
	'file-excel',
	'file-export',
	'file-image',
	'file-import',
	'file-invoice',
	'file-invoice-dollar',
	'file-medical',
	'file-medical-alt',
	'file-pdf',
	'file-powerpoint',
	'file-prescription',
	'file-signature',
	'file-upload',
	'file-video',
	'file-word',
	'fill',
	'fill-drip',
	'film',
	'filter',
	'fingerprint',
	'fire',
	'fire-alt',
	'fire-extinguisher',
	'first-aid',
	'fish',
	'fist-raised',
	'flag',
	'flag-checkered',
	'flag-usa',
	'flask',
	'flushed',
	'folder',
	'folder-minus',
	'folder-open',
	'folder-plus',
	'font',
	'football-ball',
	'forward',
	'frog',
	'frown',
	'frown-open',
	'funnel-dollar',
	'futbol',
	'gamepad',
	'gas-pump',
	'gavel',
	'gem',
	'genderless',
	'ghost',
	'gift',
	'gifts',
	'glass-cheers',
	'glass-martini',
	'glass-martini-alt',
	'glass-whiskey',
	'glasses',
	'globe',
	'globe-africa',
	'globe-americas',
	'globe-asia',
	'globe-europe',
	'golf-ball',
	'gopuram',
	'graduation-cap',
	'greater-than',
	'greater-than-equal',
	'grimace',
	'grin',
	'grin-alt',
	'grin-beam',
	'grin-beam-sweat',
	'grin-hearts',
	'grin-squint',
	'grin-squint-tears',
	'grin-stars',
	'grin-tears',
	'grin-tongue',
	'grin-tongue-squint',
	'grin-tongue-wink',
	'grin-wink',
	'grip-horizontal',
	'grip-lines',
	'grip-lines-vertical',
	'grip-vertical',
	'guitar',
	'h-square',
	'hamburger',
	'hammer',
	'hamsa',
	'hand-holding',
	'hand-holding-heart',
	'hand-holding-usd',
	'hand-lizard',
	'hand-middle-finger',
	'hand-paper',
	'hand-peace',
	'hand-point-down',
	'hand-point-left',
	'hand-point-right',
	'hand-point-up',
	'hand-pointer',
	'hand-rock',
	'hand-scissors',
	'hand-spock',
	'hands',
	'hands-helping',
	'handshake',
	'hanukiah',
	'hard-hat',
	'hashtag',
	'hat-cowboy',
	'hat-cowboy-side',
	'hat-wizard',
	'hdd',
	'heading',
	'headphones',
	'headphones-alt',
	'headset',
	'heart',
	'heart-broken',
	'heartbeat',
	'helicopter',
	'highlighter',
	'hiking',
	'hippo',
	'history',
	'hockey-puck',
	'holly-berry',
	'home',
	'horse',
	'horse-head',
	'hospital',
	'hospital-alt',
	'hospital-symbol',
	'hot-tub',
	'hotdog',
	'hotel',
	'hourglass',
	'hourglass-end',
	'hourglass-half',
	'hourglass-start',
	'house-damage',
	'hryvnia',
	'i-cursor',
	'ice-cream',
	'icicles',
	'icons',
	'id-badge',
	'id-card',
	'id-card-alt',
	'igloo',
	'image',
	'images',
	'inbox',
	'indent',
	'industry',
	'infinity',
	'info',
	'info-circle',
	'italic',
	'jedi',
	'joint',
	'journal-whills',
	'kaaba',
	'key',
	'keyboard',
	'khanda',
	'kiss',
	'kiss-beam',
	'kiss-wink-heart',
	'kiwi-bird',
	'landmark',
	'language',
	'laptop',
	'laptop-code',
	'laptop-medical',
	'laugh',
	'laugh-beam',
	'laugh-squint',
	'laugh-wink',
	'layer-group',
	'leaf',
	'lemon',
	'less-than',
	'less-than-equal',
	'level-down-alt',
	'level-up-alt',
	'life-ring',
	'lightbulb',
	'link',
	'lira-sign',
	'list',
	'list-alt',
	'list-ol',
	'list-ul',
	'location-arrow',
	'lock',
	'lock-open',
	'long-arrow-alt-down',
	'long-arrow-alt-left',
	'long-arrow-alt-right',
	'long-arrow-alt-up',
	'low-vision',
	'luggage-cart',
	'magic',
	'magnet',
	'mail-bulk',
	'male',
	'map',
	'map-marked',
	'map-marked-alt',
	'map-marker',
	'map-marker-alt',
	'map-pin',
	'map-signs',
	'marker',
	'mars',
	'mars-double',
	'mars-stroke',
	'mars-stroke-h',
	'mars-stroke-v',
	'mask',
	'medal',
	'medkit',
	'meh',
	'meh-blank',
	'meh-rolling-eyes',
	'memory',
	'menorah',
	'mercury',
	'meteor',
	'microchip',
	'microphone',
	'microphone-alt',
	'microphone-alt-slash',
	'microphone-slash',
	'microscope',
	'minus',
	'minus-circle',
	'minus-square',
	'mitten',
	'mobile',
	'mobile-alt',
	'money-bill',
	'money-bill-alt',
	'money-bill-wave',
	'money-bill-wave-alt',
	'money-check',
	'money-check-alt',
	'monument',
	'moon',
	'mortar-pestle',
	'mosque',
	'motorcycle',
	'mountain',
	'mouse',
	'mouse-pointer',
	'mug-hot',
	'music',
	'network-wired',
	'neuter',
	'newspaper',
	'not-equal',
	'notes-medical',
	'object-group',
	'object-ungroup',
	'oil-can',
	'om',
	'otter',
	'outdent',
	'pager',
	'paint-brush',
	'paint-roller',
	'palette',
	'pallet',
	'paper-plane',
	'paperclip',
	'parachute-box',
	'paragraph',
	'parking',
	'passport',
	'pastafarianism',
	'paste',
	'pause',
	'pause-circle',
	'paw',
	'peace',
	'pen',
	'pen-alt',
	'pen-fancy',
	'pen-nib',
	'pen-square',
	'pencil-alt',
	'pencil-ruler',
	'people-carry',
	'pepper-hot',
	'percent',
	'percentage',
	'person-booth',
	'phone',
	'phone-alt',
	'phone-slash',
	'phone-square',
	'phone-square-alt',
	'phone-volume',
	'photo-video',
	'piggy-bank',
	'pills',
	'pizza-slice',
	'place-of-worship',
	'plane',
	'plane-arrival',
	'plane-departure',
	'play',
	'play-circle',
	'plug',
	'plus',
	'plus-circle',
	'plus-square',
	'podcast',
	'poll',
	'poll-h',
	'poo',
	'poo-storm',
	'poop',
	'portrait',
	'pound-sign',
	'power-off',
	'pray',
	'praying-hands',
	'prescription',
	'prescription-bottle',
	'prescription-bottle-alt',
	'print',
	'procedures',
	'project-diagram',
	'puzzle-piece',
	'qrcode',
	'question',
	'question-circle',
	'quidditch',
	'quote-left',
	'quote-right',
	'quran',
	'radiation',
	'radiation-alt',
	'rainbow',
	'random',
	'receipt',
	'record-vinyl',
	'recycle',
	'redo',
	'redo-alt',
	'registered',
	'remove-format',
	'reply',
	'reply-all',
	'republican',
	'restroom',
	'retweet',
	'ribbon',
	'ring',
	'road',
	'robot',
	'rocket',
	'route',
	'rss',
	'rss-square',
	'ruble-sign',
	'ruler',
	'ruler-combined',
	'ruler-horizontal',
	'ruler-vertical',
	'running',
	'rupee-sign',
	'sad-cry',
	'sad-tear',
	'satellite',
	'satellite-dish',
	'save',
	'school',
	'screwdriver',
	'scroll',
	'sd-card',
	'search',
	'search-dollar',
	'search-location',
	'search-minus',
	'search-plus',
	'seedling',
	'server',
	'shapes',
	'share',
	'share-alt',
	'share-alt-square',
	'share-square',
	'shekel-sign',
	'shield-alt',
	'ship',
	'shipping-fast',
	'shoe-prints',
	'shopping-bag',
	'shopping-basket',
	'shopping-cart',
	'shower',
	'shuttle-van',
	'sign',
	'sign-in-alt',
	'sign-language',
	'sign-out-alt',
	'signal',
	'signature',
	'sim-card',
	'sitemap',
	'skating',
	'skiing',
	'skiing-nordic',
	'skull',
	'skull-crossbones',
	'slash',
	'sleigh',
	'sliders-h',
	'smile',
	'smile-beam',
	'smile-wink',
	'smog',
	'smoking',
	'smoking-ban',
	'sms',
	'snowboarding',
	'snowflake',
	'snowman',
	'snowplow',
	'socks',
	'solar-panel',
	'sort',
	'sort-alpha-down',
	'sort-alpha-down-alt',
	'sort-alpha-up',
	'sort-alpha-up-alt',
	'sort-amount-down',
	'sort-amount-down-alt',
	'sort-amount-up',
	'sort-amount-up-alt',
	'sort-down',
	'sort-numeric-down',
	'sort-numeric-down-alt',
	'sort-numeric-up',
	'sort-numeric-up-alt',
	'sort-up',
	'spa',
	'space-shuttle',
	'spell-check',
	'spider',
	'spinner',
	'splotch',
	'spray-can',
	'square',
	'square-full',
	'square-root-alt',
	'stamp',
	'star',
	'star-and-crescent',
	'star-half',
	'star-half-alt',
	'star-of-david',
	'star-of-life',
	'step-backward',
	'step-forward',
	'stethoscope',
	'sticky-note',
	'stop',
	'stop-circle',
	'stopwatch',
	'store',
	'store-alt',
	'stream',
	'street-view',
	'strikethrough',
	'stroopwafel',
	'subscript',
	'subway',
	'suitcase',
	'suitcase-rolling',
	'sun',
	'superscript',
	'surprise',
	'swatchbook',
	'swimmer',
	'swimming-pool',
	'synagogue',
	'sync',
	'sync-alt',
	'syringe',
	'table',
	'table-tennis',
	'tablet',
	'tablet-alt',
	'tablets',
	'tachometer-alt',
	'tag',
	'tags',
	'tape',
	'tasks',
	'taxi',
	'teeth',
	'teeth-open',
	'temperature-high',
	'temperature-low',
	'tenge',
	'terminal',
	'text-height',
	'text-width',
	'th',
	'th-large',
	'th-list',
	'theater-masks',
	'thermometer',
	'thermometer-empty',
	'thermometer-full',
	'thermometer-half',
	'thermometer-quarter',
	'thermometer-three-quarters',
	'thumbs-down',
	'thumbs-up',
	'thumbtack',
	'ticket-alt',
	'times',
	'times-circle',
	'tint',
	'tint-slash',
	'tired',
	'toggle-off',
	'toggle-on',
	'toilet',
	'toilet-paper',
	'toolbox',
	'tools',
	'tooth',
	'torah',
	'torii-gate',
	'tractor',
	'trademark',
	'traffic-light',
	'trailer',
	'train',
	'tram',
	'transgender',
	'transgender-alt',
	'trash',
	'trash-alt',
	'trash-restore',
	'trash-restore-alt',
	'tree',
	'trophy',
	'truck',
	'truck-loading',
	'truck-monster',
	'truck-moving',
	'truck-pickup',
	'tshirt',
	'tty',
	'tv',
	'umbrella',
	'umbrella-beach',
	'underline',
	'undo',
	'undo-alt',
	'universal-access',
	'university',
	'unlink',
	'unlock',
	'unlock-alt',
	'upload',
	'user',
	'user-alt',
	'user-alt-slash',
	'user-astronaut',
	'user-check',
	'user-circle',
	'user-clock',
	'user-cog',
	'user-edit',
	'user-friends',
	'user-graduate',
	'user-injured',
	'user-lock',
	'user-md',
	'user-minus',
	'user-ninja',
	'user-nurse',
	'user-plus',
	'user-secret',
	'user-shield',
	'user-slash',
	'user-tag',
	'user-tie',
	'user-times',
	'users',
	'users-cog',
	'utensil-spoon',
	'utensils',
	'vector-square',
	'venus',
	'venus-double',
	'venus-mars',
	'vial',
	'vials',
	'video',
	'video-slash',
	'vihara',
	'voicemail',
	'volleyball-ball',
	'volume-down',
	'volume-mute',
	'volume-off',
	'volume-up',
	'vote-yea',
	'vr-cardboard',
	'walking',
	'wallet',
	'warehouse',
	'water',
	'wave-square',
	'weight',
	'weight-hanging',
	'wheelchair',
	'wifi',
	'wind',
	'window-close',
	'window-maximize',
	'window-minimize',
	'window-restore',
	'wine-bottle',
	'wine-glass',
	'wine-glass-alt',
	'won-sign',
	'wrench',
	'x-ray',
	'yen-sign',
	'yin-yang'
];

var iconarray_elementor_icons_fa_brands = [
	'',
	'500px',
	'accessible-icon',
	'accusoft',
	'acquisitions-incorporated',
	'adn',
	'adobe',
	'adversal',
	'affiliatetheme',
	'airbnb',
	'algolia',
	'alipay',
	'amazon',
	'amazon-pay',
	'amilia',
	'android',
	'angellist',
	'angrycreative',
	'angular',
	'app-store',
	'app-store-ios',
	'apper',
	'apple',
	'apple-pay',
	'artstation',
	'asymmetrik',
	'atlassian',
	'audible',
	'autoprefixer',
	'avianex',
	'aviato',
	'aws',
	'bandcamp',
	'battle-net',
	'behance',
	'behance-square',
	'bimobject',
	'bitbucket',
	'bitcoin',
	'bity',
	'black-tie',
	'blackberry',
	'blogger',
	'blogger-b',
	'bluetooth',
	'bluetooth-b',
	'bootstrap',
	'btc',
	'buffer',
	'buromobelexperte',
	'buy-n-large',
	'buysellads',
	'canadian-maple-leaf',
	'cc-amazon-pay',
	'cc-amex',
	'cc-apple-pay',
	'cc-diners-club',
	'cc-discover',
	'cc-jcb',
	'cc-mastercard',
	'cc-paypal',
	'cc-stripe',
	'cc-visa',
	'centercode',
	'centos',
	'chrome',
	'chromecast',
	'cloudscale',
	'cloudsmith',
	'cloudversify',
	'codepen',
	'codiepie',
	'confluence',
	'connectdevelop',
	'contao',
	'cotton-bureau',
	'cpanel',
	'creative-commons',
	'creative-commons-by',
	'creative-commons-nc',
	'creative-commons-nc-eu',
	'creative-commons-nc-jp',
	'creative-commons-nd',
	'creative-commons-pd',
	'creative-commons-pd-alt',
	'creative-commons-remix',
	'creative-commons-sa',
	'creative-commons-sampling',
	'creative-commons-sampling-plus',
	'creative-commons-share',
	'creative-commons-zero',
	'critical-role',
	'css3',
	'css3-alt',
	'cuttlefish',
	'd-and-d',
	'd-and-d-beyond',
	'dashcube',
	'delicious',
	'deploydog',
	'deskpro',
	'dev',
	'deviantart',
	'dhl',
	'diaspora',
	'digg',
	'digital-ocean',
	'discord',
	'discourse',
	'dochub',
	'docker',
	'draft2digital',
	'dribbble',
	'dribbble-square',
	'dropbox',
	'drupal',
	'dyalog',
	'earlybirds',
	'ebay',
	'edge',
	'elementor',
	'ello',
	'ember',
	'empire',
	'envira',
	'erlang',
	'ethereum',
	'etsy',
	'evernote',
	'expeditedssl',
	'facebook',
	'facebook-f',
	'facebook-messenger',
	'facebook-square',
	'fantasy-flight-games',
	'fedex',
	'fedora',
	'figma',
	'firefox',
	'firefox-browser',
	'first-order',
	'first-order-alt',
	'firstdraft',
	'flickr',
	'flipboard',
	'fly',
	'font-awesome',
	'font-awesome-alt',
	'font-awesome-flag',
	'fonticons',
	'fonticons-fi',
	'fort-awesome',
	'fort-awesome-alt',
	'forumbee',
	'foursquare',
	'free-code-camp',
	'freebsd',
	'fulcrum',
	'galactic-republic',
	'galactic-senate',
	'get-pocket',
	'gg',
	'gg-circle',
	'git',
	'git-alt',
	'git-square',
	'github',
	'github-alt',
	'github-square',
	'gitkraken',
	'gitlab',
	'gitter',
	'glide',
	'glide-g',
	'gofore',
	'goodreads',
	'goodreads-g',
	'google',
	'google-drive',
	'google-play',
	'google-plus',
	'google-plus-g',
	'google-plus-square',
	'google-wallet',
	'gratipay',
	'grav',
	'gripfire',
	'grunt',
	'gulp',
	'hacker-news',
	'hacker-news-square',
	'hackerrank',
	'hips',
	'hire-a-helper',
	'hooli',
	'hornbill',
	'hotjar',
	'houzz',
	'html5',
	'hubspot',
	'ideal',
	'imdb',
	'instagram',
	'intercom',
	'internet-explorer',
	'invision',
	'ioxhost',
	'itch-io',
	'itunes',
	'itunes-note',
	'java',
	'jedi-order',
	'jenkins',
	'jira',
	'joget',
	'joomla',
	'js',
	'js-square',
	'jsfiddle',
	'kaggle',
	'keybase',
	'keycdn',
	'kickstarter',
	'kickstarter-k',
	'korvue',
	'laravel',
	'lastfm',
	'lastfm-square',
	'leanpub',
	'less',
	'line',
	'linkedin',
	'linkedin-in',
	'linode',
	'linux',
	'lyft',
	'magento',
	'mailchimp',
	'mandalorian',
	'markdown',
	'mastodon',
	'maxcdn',
	'mdb',
	'medapps',
	'medium',
	'medium-m',
	'medrt',
	'meetup',
	'megaport',
	'mendeley',
	'microblog',
	'microsoft',
	'mix',
	'mixcloud',
	'mizuni',
	'modx',
	'monero',
	'napster',
	'neos',
	'nimblr',
	'node',
	'node-js',
	'npm',
	'ns8',
	'nutritionix',
	'odnoklassniki',
	'odnoklassniki-square',
	'old-republic',
	'opencart',
	'openid',
	'opera',
	'optin-monster',
	'orcid',
	'osi',
	'page4',
	'pagelines',
	'palfed',
	'patreon',
	'paypal',
	'penny-arcade',
	'periscope',
	'phabricator',
	'phoenix-framework',
	'phoenix-squadron',
	'php',
	'pied-piper',
	'pied-piper-alt',
	'pied-piper-hat',
	'pied-piper-pp',
	'pied-piper-square',
	'pinterest',
	'pinterest-p',
	'pinterest-square',
	'playstation',
	'product-hunt',
	'pushed',
	'python',
	'qq',
	'quinscape',
	'quora',
	'r-project',
	'raspberry-pi',
	'ravelry',
	'react',
	'reacteurope',
	'readme',
	'rebel',
	'red-river',
	'reddit',
	'reddit-alien',
	'reddit-square',
	'redhat',
	'renren',
	'replyd',
	'researchgate',
	'resolving',
	'rev',
	'rocketchat',
	'rockrms',
	'safari',
	'salesforce',
	'sass',
	'schlix',
	'scribd',
	'searchengin',
	'sellcast',
	'sellsy',
	'servicestack',
	'shirtsinbulk',
	'shopware',
	'simplybuilt',
	'sistrix',
	'sith',
	'sketch',
	'skyatlas',
	'skype',
	'slack',
	'slack-hash',
	'slideshare',
	'snapchat',
	'snapchat-ghost',
	'snapchat-square',
	'soundcloud',
	'sourcetree',
	'speakap',
	'speaker-deck',
	'spotify',
	'squarespace',
	'stack-exchange',
	'stack-overflow',
	'stackpath',
	'staylinked',
	'steam',
	'steam-square',
	'steam-symbol',
	'sticker-mule',
	'strava',
	'stripe',
	'stripe-s',
	'studiovinari',
	'stumbleupon',
	'stumbleupon-circle',
	'superpowers',
	'supple',
	'suse',
	'swift',
	'symfony',
	'teamspeak',
	'telegram',
	'telegram-plane',
	'tencent-weibo',
	'the-red-yeti',
	'themeco',
	'themeisle',
	'think-peaks',
	'trade-federation',
	'trello',
	'tripadvisor',
	'tumblr',
	'tumblr-square',
	'twitch',
	'twitter',
	'twitter-square',
	'typo3',
	'uber',
	'ubuntu',
	'uikit',
	'umbraco',
	'uniregistry',
	'unity',
	'untappd',
	'ups',
	'usb',
	'usps',
	'ussunnah',
	'vaadin',
	'viacoin',
	'viadeo',
	'viadeo-square',
	'viber',
	'vimeo',
	'vimeo-square',
	'vimeo-v',
	'vine',
	'vk',
	'vnv',
	'vuejs',
	'waze',
	'weebly',
	'weibo',
	'weixin',
	'whatsapp',
	'whatsapp-square',
	'whmcs',
	'wikipedia-w',
	'windows',
	'wix',
	'wizards-of-the-coast',
	'wolf-pack-battalion',
	'wordpress',
	'wordpress-simple',
	'wpbeginner',
	'wpexplorer',
	'wpforms',
	'wpressr',
	'xbox',
	'xing',
	'xing-square',
	'y-combinator',
	'yahoo',
	'yammer',
	'yandex',
	'yandex-international',
	'yarn',
	'yelp',
	'yoast',
	'youtube',
	'youtube-square',
	'zhihu'
]

var iconarray_material_icons = [
	'',
	'3d-rotation',
	'ac-unit',
	'access-alarm',
	'access-alarms',
	'access-time',
	'accessibility',
	'accessible',
	'account-balance',
	'account-balance-wallet',
	'account-box',
	'account-circle',
	'adb',
	'add',
	'add-a-photo',
	'add-alarm',
	'add-alert',
	'add-box',
	'add-circle',
	'add-circle-outline',
	'add-location',
	'add-shopping-cart',
	'add-to-photos',
	'add-to-queue',
	'adjust',
	'airline-seat-flat',
	'airline-seat-flat-angled',
	'airline-seat-individual-suite',
	'airline-seat-legroom-extra',
	'airline-seat-legroom-normal',
	'airline-seat-legroom-reduced',
	'airline-seat-recline-extra',
	'airline-seat-recline-normal',
	'airplanemode-active',
	'airplanemode-inactive',
	'airplay',
	'airport-shuttle',
	'alarm',
	'alarm-add',
	'alarm-off',
	'alarm-on',
	'album',
	'all-inclusive',
	'all-out',
	'android',
	'announcement',
	'apps',
	'archive',
	'arrow-back',
	'arrow-downward',
	'arrow-drop-down',
	'arrow-drop-down-circle',
	'arrow-drop-up',
	'arrow-forward',
	'arrow-upward',
	'art-track',
	'aspect-ratio',
	'assessment',
	'assignment',
	'assignment-ind',
	'assignment-late',
	'assignment-return',
	'assignment-returned',
	'assignment-turned-in',
	'assistant',
	'assistant-photo',
	'attach-file',
	'attach-money',
	'attachment',
	'audiotrack',
	'autorenew',
	'av-timer',
	'backspace',
	'backup',
	'battery-alert',
	'battery-charging-full',
	'battery-full',
	'battery-std',
	'battery-unknown',
	'beach-access',
	'beenhere',
	'block',
	'bluetooth',
	'bluetooth-audio',
	'bluetooth-connected',
	'bluetooth-disabled',
	'bluetooth-searching',
	'blur-circular',
	'blur-linear',
	'blur-off',
	'blur-on',
	'book',
	'bookmark',
	'bookmark-border',
	'border-all',
	'border-bottom',
	'border-clear',
	'border-color',
	'border-horizontal',
	'border-inner',
	'border-left',
	'border-outer',
	'border-right',
	'border-style',
	'border-top',
	'border-vertical',
	'branding-watermark',
	'brightness-1',
	'brightness-2',
	'brightness-3',
	'brightness-4',
	'brightness-5',
	'brightness-6',
	'brightness-7',
	'brightness-auto',
	'brightness-high',
	'brightness-low',
	'brightness-medium',
	'broken-image',
	'brush',
	'bubble-chart',
	'bug-report',
	'build',
	'burst-mode',
	'business',
	'business-center',
	'cached',
	'cake',
	'call',
	'call-end',
	'call-made',
	'call-merge',
	'call-missed',
	'call-missed-outgoing',
	'call-received',
	'call-split',
	'call-to-action',
	'camera',
	'camera-alt',
	'camera-enhance',
	'camera-front',
	'camera-rear',
	'camera-roll',
	'cancel',
	'card-giftcard',
	'card-membership',
	'card-travel',
	'casino',
	'cast',
	'cast-connected',
	'center-focus-strong',
	'center-focus-weak',
	'change-history',
	'chat',
	'chat-bubble',
	'chat-bubble-outline',
	'check',
	'check-box',
	'check-box-outline-blank',
	'check-circle',
	'chevron-left',
	'chevron-right',
	'child-care',
	'child-friendly',
	'chrome-reader-mode',
	'class',
	'clear',
	'clear-all',
	'close',
	'closed-caption',
	'cloud',
	'cloud-circle',
	'cloud-done',
	'cloud-download',
	'cloud-off',
	'cloud-queue',
	'cloud-upload',
	'code',
	'collections',
	'collections-bookmark',
	'color-lens',
	'colorize',
	'comment',
	'compare',
	'compare-arrows',
	'computer',
	'confirmation-number',
	'contact-mail',
	'contact-phone',
	'contacts',
	'content-copy',
	'content-cut',
	'content-paste',
	'control-point',
	'control-point-duplicate',
	'copyright',
	'create',
	'create-new-folder',
	'credit-card',
	'crop',
	'crop-16-9',
	'crop-3-2',
	'crop-5-4',
	'crop-7-5',
	'crop-din',
	'crop-free',
	'crop-landscape',
	'crop-original',
	'crop-portrait',
	'crop-rotate',
	'crop-square',
	'dashboard',
	'data-usage',
	'date-range',
	'dehaze',
	'delete',
	'delete-forever',
	'delete-sweep',
	'description',
	'desktop-mac',
	'desktop-windows',
	'details',
	'developer-board',
	'developer-mode',
	'device-hub',
	'devices',
	'devices-other',
	'dialer-sip',
	'dialpad',
	'directions',
	'directions-bike',
	'directions-boat',
	'directions-bus',
	'directions-car',
	'directions-railway',
	'directions-run',
	'directions-subway',
	'directions-transit',
	'directions-walk',
	'disc-full',
	'dns',
	'do-not-disturb',
	'do-not-disturb-alt',
	'do-not-disturb-off',
	'do-not-disturb-on',
	'dock',
	'domain',
	'done',
	'done-all',
	'donut-large',
	'donut-small',
	'drafts',
	'drag-handle',
	'drive-eta',
	'dvr',
	'edit',
	'edit-location',
	'eject',
	'email',
	'enhanced-encryption',
	'equalizer',
	'error',
	'error-outline',
	'euro-symbol',
	'ev-station',
	'event',
	'event-available',
	'event-busy',
	'event-note',
	'event-seat',
	'exit-to-app',
	'expand-less',
	'expand-more',
	'explicit',
	'explore',
	'exposure',
	'exposure-neg-1',
	'exposure-neg-2',
	'exposure-plus-1',
	'exposure-plus-2',
	'exposure-zero',
	'extension',
	'face',
	'fast-forward',
	'fast-rewind',
	'favorite',
	'favorite-border',
	'featured-play-list',
	'featured-video',
	'feedback',
	'fiber-dvr',
	'fiber-manual-record',
	'fiber-new',
	'fiber-pin',
	'fiber-smart-record',
	'file-download',
	'file-upload',
	'filter',
	'filter-1',
	'filter-2',
	'filter-3',
	'filter-4',
	'filter-5',
	'filter-6',
	'filter-7',
	'filter-8',
	'filter-9',
	'filter-9-plus',
	'filter-b-and-w',
	'filter-center-focus',
	'filter-drama',
	'filter-frames',
	'filter-hdr',
	'filter-list',
	'filter-none',
	'filter-tilt-shift',
	'filter-vintage',
	'find-in-page',
	'find-replace',
	'fingerprint',
	'first-page',
	'fitness-center',
	'flag',
	'flare',
	'flash-auto',
	'flash-off',
	'flash-on',
	'flight',
	'flight-land',
	'flight-takeoff',
	'flip',
	'flip-to-back',
	'flip-to-front',
	'folder',
	'folder-open',
	'folder-shared',
	'folder-special',
	'font-download',
	'format-align-center',
	'format-align-justify',
	'format-align-left',
	'format-align-right',
	'format-bold',
	'format-clear',
	'format-color-fill',
	'format-color-reset',
	'format-color-text',
	'format-indent-decrease',
	'format-indent-increase',
	'format-italic',
	'format-line-spacing',
	'format-list-bulleted',
	'format-list-numbered',
	'format-paint',
	'format-quote',
	'format-shapes',
	'format-size',
	'format-strikethrough',
	'format-textdirection-l-to-r',
	'format-textdirection-r-to-l',
	'format-underlined',
	'forum',
	'forward',
	'forward-10',
	'forward-30',
	'forward-5',
	'free-breakfast',
	'fullscreen',
	'fullscreen-exit',
	'functions',
	'g-translate',
	'gamepad',
	'games',
	'gavel',
	'gesture',
	'get-app',
	'gif',
	'golf-course',
	'gps-fixed',
	'gps-not-fixed',
	'gps-off',
	'grade',
	'gradient',
	'grain',
	'graphic-eq',
	'grid-off',
	'grid-on',
	'group',
	'group-add',
	'group-work',
	'hd',
	'hdr-off',
	'hdr-on',
	'hdr-strong',
	'hdr-weak',
	'headset',
	'headset-mic',
	'healing',
	'hearing',
	'help',
	'help-outline',
	'high-quality',
	'highlight',
	'highlight-off',
	'history',
	'home',
	'hot-tub',
	'hotel',
	'hourglass-empty',
	'hourglass-full',
	'http',
	'https',
	'image',
	'image-aspect-ratio',
	'import-contacts',
	'import-export',
	'important-devices',
	'inbox',
	'indeterminate-check-box',
	'info',
	'info-outline',
	'input',
	'insert-chart',
	'insert-comment',
	'insert-drive-file',
	'insert-emoticon',
	'insert-invitation',
	'insert-link',
	'insert-photo',
	'invert-colors',
	'invert-colors-off',
	'iso',
	'keyboard',
	'keyboard-arrow-down',
	'keyboard-arrow-left',
	'keyboard-arrow-right',
	'keyboard-arrow-up',
	'keyboard-backspace',
	'keyboard-capslock',
	'keyboard-hide',
	'keyboard-return',
	'keyboard-tab',
	'keyboard-voice',
	'kitchen',
	'label',
	'label-outline',
	'landscape',
	'language',
	'laptop',
	'laptop-chromebook',
	'laptop-mac',
	'laptop-windows',
	'last-page',
	'launch',
	'layers',
	'layers-clear',
	'leak-add',
	'leak-remove',
	'lens',
	'library-add',
	'library-books',
	'library-music',
	'lightbulb-outline',
	'line-style',
	'line-weight',
	'linear-scale',
	'link',
	'linked-camera',
	'list',
	'live-help',
	'live-tv',
	'local-activity',
	'local-airport',
	'local-atm',
	'local-bar',
	'local-cafe',
	'local-car-wash',
	'local-convenience-store',
	'local-dining',
	'local-drink',
	'local-florist',
	'local-gas-station',
	'local-grocery-store',
	'local-hospital',
	'local-hotel',
	'local-laundry-service',
	'local-library',
	'local-mall',
	'local-movies',
	'local-offer',
	'local-parking',
	'local-pharmacy',
	'local-phone',
	'local-pizza',
	'local-play',
	'local-post-office',
	'local-printshop',
	'local-see',
	'local-shipping',
	'local-taxi',
	'location-city',
	'location-disabled',
	'location-off',
	'location-on',
	'location-searching',
	'lock',
	'lock-open',
	'lock-outline',
	'looks',
	'looks-3',
	'looks-4',
	'looks-5',
	'looks-6',
	'looks-one',
	'looks-two',
	'loop',
	'loupe',
	'low-priority',
	'loyalty',
	'mail',
	'mail-outline',
	'map',
	'markunread',
	'markunread-mailbox',
	'memory',
	'menu',
	'merge-type',
	'message',
	'mic',
	'mic-none',
	'mic-off',
	'mms',
	'mode-comment',
	'mode-edit',
	'monetization-on',
	'money-off',
	'monochrome-photos',
	'mood',
	'mood-bad',
	'more',
	'more-horiz',
	'more-vert',
	'motorcycle',
	'mouse',
	'move-to-inbox',
	'movie',
	'movie-creation',
	'movie-filter',
	'multiline-chart',
	'music-note',
	'music-video',
	'my-location',
	'nature',
	'nature-people',
	'navigate-before',
	'navigate-next',
	'navigation',
	'near-me',
	'network-cell',
	'network-check',
	'network-locked',
	'network-wifi',
	'new-releases',
	'next-week',
	'nfc',
	'no-encryption',
	'no-sim',
	'not-interested',
	'note',
	'note-add',
	'notifications',
	'notifications-active',
	'notifications-none',
	'notifications-off',
	'notifications-paused',
	'offline-pin',
	'ondemand-video',
	'opacity',
	'open-in-browser',
	'open-in-new',
	'open-with',
	'pages',
	'pageview',
	'palette',
	'pan-tool',
	'panorama',
	'panorama-fish-eye',
	'panorama-horizontal',
	'panorama-vertical',
	'panorama-wide-angle',
	'party-mode',
	'pause',
	'pause-circle-filled',
	'pause-circle-outline',
	'payment',
	'people',
	'people-outline',
	'perm-camera-mic',
	'perm-contact-calendar',
	'perm-data-setting',
	'perm-device-information',
	'perm-identity',
	'perm-media',
	'perm-phone-msg',
	'perm-scan-wifi',
	'person',
	'person-add',
	'person-outline',
	'person-pin',
	'person-pin-circle',
	'personal-video',
	'pets',
	'phone',
	'phone-android',
	'phone-bluetooth-speaker',
	'phone-forwarded',
	'phone-in-talk',
	'phone-iphone',
	'phone-locked',
	'phone-missed',
	'phone-paused',
	'phonelink',
	'phonelink-erase',
	'phonelink-lock',
	'phonelink-off',
	'phonelink-ring',
	'phonelink-setup',
	'photo',
	'photo-album',
	'photo-camera',
	'photo-filter',
	'photo-library',
	'photo-size-select-actual',
	'photo-size-select-large',
	'photo-size-select-small',
	'picture-as-pdf',
	'picture-in-picture',
	'picture-in-picture-alt',
	'pie-chart',
	'pie-chart-outlined',
	'pin-drop',
	'place',
	'play-arrow',
	'play-circle-filled',
	'play-circle-outline',
	'play-for-work',
	'playlist-add',
	'playlist-add-check',
	'playlist-play',
	'plus-one',
	'poll',
	'polymer',
	'pool',
	'portable-wifi-off',
	'portrait',
	'power',
	'power-input',
	'power-settings-new',
	'pregnant-woman',
	'present-to-all',
	'print',
	'priority-high',
	'public',
	'publish',
	'query-builder',
	'question-answer',
	'queue',
	'queue-music',
	'queue-play-next',
	'radio',
	'radio-button-checked',
	'radio-button-unchecked',
	'rate-review',
	'receipt',
	'recent-actors',
	'record-voice-over',
	'redeem',
	'redo',
	'refresh',
	'remove',
	'remove-circle',
	'remove-circle-outline',
	'remove-from-queue',
	'remove-red-eye',
	'remove-shopping-cart',
	'reorder',
	'repeat',
	'repeat-one',
	'replay',
	'replay-10',
	'replay-30',
	'replay-5',
	'reply',
	'reply-all',
	'report',
	'report-problem',
	'restaurant',
	'restaurant-menu',
	'restore',
	'restore-page',
	'ring-volume',
	'room',
	'room-service',
	'rotate-90-degrees-ccw',
	'rotate-left',
	'rotate-right',
	'rounded-corner',
	'router',
	'rowing',
	'rss-feed',
	'rv-hookup',
	'satellite',
	'save',
	'scanner',
	'schedule',
	'school',
	'screen-lock-landscape',
	'screen-lock-portrait',
	'screen-lock-rotation',
	'screen-rotation',
	'screen-share',
	'sd-card',
	'sd-storage',
	'search',
	'security',
	'select-all',
	'send',
	'sentiment-dissatisfied',
	'sentiment-neutral',
	'sentiment-satisfied',
	'sentiment-very-dissatisfied',
	'sentiment-very-satisfied',
	'settings',
	'settings-applications',
	'settings-backup-restore',
	'settings-bluetooth',
	'settings-brightness',
	'settings-cell',
	'settings-ethernet',
	'settings-input-antenna',
	'settings-input-component',
	'settings-input-composite',
	'settings-input-hdmi',
	'settings-input-svideo',
	'settings-overscan',
	'settings-phone',
	'settings-power',
	'settings-remote',
	'settings-system-daydream',
	'settings-voice',
	'share',
	'shop',
	'shop-two',
	'shopping-basket',
	'shopping-cart',
	'short-text',
	'show-chart',
	'shuffle',
	'signal-cellular-4-bar',
	'signal-cellular-connected-no-internet-4-bar',
	'signal-cellular-no-sim',
	'signal-cellular-null',
	'signal-cellular-off',
	'signal-wifi-4-bar',
	'signal-wifi-4-bar-lock',
	'signal-wifi-off',
	'sim-card',
	'sim-card-alert',
	'skip-next',
	'skip-previous',
	'slideshow',
	'slow-motion-video',
	'smartphone',
	'smoke-free',
	'smoking-rooms',
	'sms',
	'sms-failed',
	'snooze',
	'sort',
	'sort-by-alpha',
	'spa',
	'space-bar',
	'speaker',
	'speaker-group',
	'speaker-notes',
	'speaker-notes-off',
	'speaker-phone',
	'spellcheck',
	'star',
	'star-border',
	'star-half',
	'stars',
	'stay-current-landscape',
	'stay-current-portrait',
	'stay-primary-landscape',
	'stay-primary-portrait',
	'stop',
	'stop-screen-share',
	'storage',
	'store',
	'store-mall-directory',
	'straighten',
	'streetview',
	'strikethrough-s',
	'style',
	'subdirectory-arrow-left',
	'subdirectory-arrow-right',
	'subject',
	'subscriptions',
	'subtitles',
	'subway',
	'supervisor-account',
	'surround-sound',
	'swap-calls',
	'swap-horiz',
	'swap-vert',
	'swap-vertical-circle',
	'switch-camera',
	'switch-video',
	'sync',
	'sync-disabled',
	'sync-problem',
	'system-update',
	'system-update-alt',
	'tab',
	'tab-unselected',
	'tablet',
	'tablet-android',
	'tablet-mac',
	'tag-faces',
	'tap-and-play',
	'terrain',
	'text-fields',
	'text-format',
	'textsms',
	'texture',
	'theaters',
	'thumb-down',
	'thumb-up',
	'thumbs-up-down',
	'time-to-leave',
	'timelapse',
	'timeline',
	'timer',
	'timer-10',
	'timer-3',
	'timer-off',
	'title',
	'toc',
	'today',
	'toll',
	'tonality',
	'touch-app',
	'toys',
	'track-changes',
	'traffic',
	'train',
	'tram',
	'transfer-within-a-station',
	'transform',
	'translate',
	'trending-down',
	'trending-flat',
	'trending-up',
	'tune',
	'turned-in',
	'turned-in-not',
	'tv',
	'unarchive',
	'undo',
	'unfold-less',
	'unfold-more',
	'update',
	'usb',
	'verified-user',
	'vertical-align-bottom',
	'vertical-align-center',
	'vertical-align-top',
	'vibration',
	'video-call',
	'video-label',
	'video-library',
	'videocam',
	'videocam-off',
	'videogame-asset',
	'view-agenda',
	'view-array',
	'view-carousel',
	'view-column',
	'view-comfy',
	'view-compact',
	'view-day',
	'view-headline',
	'view-list',
	'view-module',
	'view-quilt',
	'view-stream',
	'view-week',
	'vignette',
	'visibility',
	'visibility-off',
	'voice-chat',
	'voicemail',
	'volume-down',
	'volume-mute',
	'volume-off',
	'volume-up',
	'vpn-key',
	'vpn-lock',
	'wallpaper',
	'warning',
	'watch',
	'watch-later',
	'wb-auto',
	'wb-cloudy',
	'wb-incandescent',
	'wb-iridescent',
	'wb-sunny',
	'wc',
	'web',
	'web-asset',
	'weekend',
	'whatshot',
	'widgets',
	'wifi',
	'wifi-lock',
	'wifi-tethering',
	'work',
	'wrap-text',
	'youtube-searched-for',
	'zoom-in',
	'zoom-out',
	'zoom-out-map'
];

// sgicon
var iconarray_sgicon = [
	'',
	'WorldWide',
	'WorldGlobe',
	'Underpants',
	'Tshirt',
	'Trousers',
	'Tie',
	'TennisBall',
	'Telesocpe',
	'Stop',
	'Starship',
	'Starship2',
	'Speaker',
	'Speaker2',
	'Soccer',
	'Snikers',
	'Scisors',
	'Puzzle',
	'Printer',
	'Pool',
	'Podium',
	'Play',
	'Planet',
	'Pause',
	'Next',
	'MusicNote2',
	'MusicNote',
	'MusicMixer',
	'Microphone',
	'Medal',
	'ManFigure',
	'Magnet',
	'Like',
	'Hanger',
	'Handicap',
	'Forward',
	'Footbal',
	'Flag',
	'FemaleFigure',
	'Dislike',
	'DiamondRing',
	'Cup',
	'Crown',
	'Column',
	'Click',
	'Cassette',
	'Bomb',
	'BatteryLow',
	'BatteryFull',
	'Bascketball',
	'Astronaut',
	'WineGlass',
	'Water',
	'Wallet',
	'Umbrella',
	'TV',
	'TeaMug',
	'Tablet',
	'Soda',
	'SodaCan',
	'SimCard',
	'Signal',
	'Shaker',
	'Radio',
	'Pizza',
	'Phone',
	'Notebook',
	'Mug',
	'Mastercard',
	'Ipod',
	'Info',
	'Icecream2',
	'Icecream1',
	'Hourglass',
	'Help',
	'Goto',
	'Glasses',
	'Gameboy',
	'ForkandKnife',
	'Export',
	'Exit',
	'Espresso',
	'Drop',
	'Download',
	'Dollars',
	'Dollar',
	'DesktopMonitor',
	'Corkscrew',
	'CoffeeToGo',
	'Chart',
	'ChartUp',
	'ChartDown',
	'Calculator',
	'Bread',
	'Bourbon',
	'BottleofWIne',
	'Bag',
	'Arrow',
	'Antenna2',
	'Antenna1',
	'Anchor',
	'Wheelbarrow',
	'Webcam',
	'Unlinked',
	'Truck',
	'Timer',
	'Time',
	'StorageBox',
	'Star',
	'ShoppingCart',
	'Shield',
	'Seringe',
	'Pulse',
	'Plaster',
	'Plaine',
	'Pill',
	'PicnicBasket',
	'Phone2',
	'Pencil',
	'Pen',
	'PaperClip',
	'On-Off',
	'Mouse',
	'Megaphone',
	'Linked',
	'Keyboard',
	'House',
	'Heart',
	'Headset',
	'FullShoppingCart',
	'FullScreen',
	'Folder',
	'Floppy',
	'Files',
	'File',
	'FileBox',
	'ExitFullScreen',
	'EmptyBox',
	'Delete',
	'Controller',
	'Compass',
	'CompassTool',
	'ClipboardText',
	'ClipboardChart',
	'ChemicalGlass',
	'CD',
	'Carioca',
	'Car',
	'Book',
	'BigTruck',
	'Bicycle',
	'Wrench',
	'Web',
	'Watch',
	'Volume',
	'Video',
	'Users',
	'User',
	'UploadCLoud',
	'Typing',
	'Tools',
	'Tag',
	'Speedometter',
	'Share',
	'Settings',
	'Search',
	'Screwdriver',
	'Rolodex',
	'Ringer',
	'Resume',
	'Restart',
	'PowerOff',
	'Pointer',
	'Picture',
	'OpenedLock',
	'Notes',
	'Mute',
	'Movie',
	'Microphone2',
	'Message',
	'MessageRight',
	'MessageLeft',
	'Menu',
	'Media',
	'Mail',
	'List',
	'Layers',
	'Key',
	'Imbox',
	'Eye',
	'Edit',
	'DSLRCamera',
	'DownloadCloud',
	'CompactCamera',
	'Cloud',
	'ClosedLock',
	'Chart2',
	'Bulb',
	'Briefcase',
	'Blog',
	'Agenda'
];

// dsvy_lyfpro_icon
var iconarray_dsvy_lyfpro_icon = [
	'',
	'business',
	'incubator',
	'startup',
	'development',
	'teamwork',
	'network',
	'program',
	'client',
	'company',
	'service',
	'model',
	'successful',
	'growth',
	'businessman',
	'crowdfunding',
	'executive',
	'coaching',
	'leadership',
	'coaching-1',
	'mentor',
	'coaching-2',
	'coach',
	'experience',
	'award',
	'trophy',
	'award-1',
	'secure-payment',
	'medal',
	'technical-support',
	'support',
	'customer-service',
	'email',
	'email-1',
	'pin',
	'call',
	'pdf',
	'doc',
	'coach-1',
	'coaching-3',
	'online-course',
	'consulting',
	'consulting-1',
	'instructor',
	'business-professional',
	'coaching-4',
	'mentor-1',
	'presentation',
	'supporter',
	'accounting',
	'presentation-1',
	'consulting-2',
	'opportunity',
	'online-business',
	'advisor',
	'right-arrow',
	'check'
];
